/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.python.antlr.ParseException;
import org.python.antlr.PythonTree;
import org.python.antlr.ast.Str;
import org.python.antlr.base.mod;
import org.python.compiler.ClassConstants;
import org.python.compiler.ClassFile;
import org.python.compiler.Code;
import org.python.compiler.CodeCompiler;
import org.python.compiler.CompilationContext;
import org.python.compiler.Constant;
import org.python.compiler.Future;
import org.python.compiler.PyCodeConstant;
import org.python.compiler.PyComplexConstant;
import org.python.compiler.PyFloatConstant;
import org.python.compiler.PyIntegerConstant;
import org.python.compiler.PyLongConstant;
import org.python.compiler.PyStringConstant;
import org.python.compiler.PyUnicodeConstant;
import org.python.compiler.ScopeInfo;
import org.python.compiler.ScopesCompiler;
import org.python.core.CodeBootstrap;
import org.python.core.CodeLoader;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyFunctionTable;
import org.python.core.PyObject;
import org.python.core.PyRunnable;
import org.python.core.PyRunnableBootstrap;
import org.python.core.ThreadState;
import org.python.objectweb.asm.Label;
import org.python.objectweb.asm.Opcodes;
import org.python.objectweb.asm.Type;
import org.python.util.CodegenUtils;

public class Module
implements Opcodes,
ClassConstants,
CompilationContext {
    ClassFile classfile;
    Constant filename;
    String sfilename;
    Constant mainCode;
    boolean linenumbers;
    Future futures;
    Hashtable<PythonTree, ScopeInfo> scopes;
    List<PyCodeConstant> codes;
    long mtime;
    Hashtable<Constant, Constant> constants;

    public Module(String string, String string2, boolean bl) {
        this(string, string2, bl, -1L);
    }

    public Module(String string, String string2, boolean bl, long l) {
        this.linenumbers = bl;
        this.mtime = l;
        this.classfile = new ClassFile(string, CodegenUtils.p(PyFunctionTable.class), 33, l);
        this.constants = new Hashtable();
        this.sfilename = string2;
        this.filename = string2 != null ? this.stringConstant(string2) : null;
        this.codes = new ArrayList<PyCodeConstant>();
        this.futures = new Future();
        this.scopes = new Hashtable();
    }

    public Module(String string) {
        this(string, string + ".py", true, -1L);
    }

    private Constant findConstant(Constant constant) {
        Constant constant2 = this.constants.get(constant);
        if (constant2 != null) {
            return constant2;
        }
        constant2 = constant;
        constant.module = this;
        constant.name = "_" + this.constants.size();
        this.constants.put(constant2, constant2);
        return constant2;
    }

    Constant integerConstant(int n) {
        return this.findConstant(new PyIntegerConstant(n));
    }

    Constant floatConstant(double d) {
        return this.findConstant(new PyFloatConstant(d));
    }

    Constant complexConstant(double d) {
        return this.findConstant(new PyComplexConstant(d));
    }

    Constant stringConstant(String string) {
        return this.findConstant(new PyStringConstant(string));
    }

    Constant unicodeConstant(String string) {
        return this.findConstant(new PyUnicodeConstant(string));
    }

    Constant longConstant(String string) {
        return this.findConstant(new PyLongConstant(string));
    }

    PyCodeConstant codeConstant(mod mod2, String string, boolean bl, String string2, boolean bl2, boolean bl3, int n, ScopeInfo scopeInfo, CompilerFlags compilerFlags) throws Exception {
        return this.codeConstant(mod2, string, bl, string2, null, bl2, bl3, n, scopeInfo, compilerFlags);
    }

    PyCodeConstant codeConstant(mod mod2, String string, boolean bl, String string2, Str str, boolean bl2, boolean bl3, int n, ScopeInfo scopeInfo, CompilerFlags compilerFlags) throws Exception {
        PyCodeConstant pyCodeConstant = new PyCodeConstant(mod2, string, bl, string2, bl2, bl3, n, scopeInfo, compilerFlags, this);
        this.codes.add(pyCodeConstant);
        CodeCompiler codeCompiler = new CodeCompiler(this, bl3);
        Code code = this.classfile.addMethod(pyCodeConstant.fname, CodegenUtils.sig(PyObject.class, PyFrame.class, ThreadState.class), 1);
        codeCompiler.parse(mod2, code, bl, string2, str, bl2, scopeInfo, compilerFlags);
        return pyCodeConstant;
    }

    public void addInit() throws IOException {
        Code code = this.classfile.addMethod("<init>", CodegenUtils.sig(Void.TYPE, String.class), 1);
        code.aload(0);
        code.invokespecial(CodegenUtils.p(PyFunctionTable.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
        this.addConstants(code);
    }

    public void addRunnable() throws IOException {
        Code code = this.classfile.addMethod("getMain", CodegenUtils.sig(PyCode.class, new Class[0]), 1);
        this.mainCode.get(code);
        code.areturn();
    }

    public void addMain() throws IOException {
        Code code = this.classfile.addMethod("main", CodegenUtils.sig(Void.TYPE, String[].class), 9);
        code.new_(this.classfile.name);
        code.dup();
        code.ldc(this.classfile.name);
        code.invokespecial(this.classfile.name, "<init>", CodegenUtils.sig(Void.TYPE, String.class));
        code.invokevirtual(this.classfile.name, "getMain", CodegenUtils.sig(PyCode.class, new Class[0]));
        code.invokestatic(CodegenUtils.p(CodeLoader.class), "createSimpleBootstrap", CodegenUtils.sig(CodeBootstrap.class, PyCode.class));
        code.aload(0);
        code.invokestatic(CodegenUtils.p(Py.class), "runMain", CodegenUtils.sig(Void.TYPE, CodeBootstrap.class, String[].class));
        code.return_();
    }

    public void addBootstrap() throws IOException {
        Code code = this.classfile.addMethod("getCodeBootstrap", CodegenUtils.sig(CodeBootstrap.class, new Class[0]), 9);
        code.ldc(Type.getType("L" + this.classfile.name + ";"));
        code.invokestatic(CodegenUtils.p(PyRunnableBootstrap.class), "getFilenameConstructorReflectionBootstrap", CodegenUtils.sig(CodeBootstrap.class, Class.class));
        code.areturn();
    }

    void addConstants(Code code) throws IOException {
        this.classfile.addField("self", "L" + this.classfile.name + ";", 8);
        code.aload(0);
        code.putstatic(this.classfile.name, "self", "L" + this.classfile.name + ";");
        Enumeration<Constant> enumeration = this.constants.elements();
        while (enumeration.hasMoreElements()) {
            Constant constant = enumeration.nextElement();
            constant.put(code);
        }
        for (int i = 0; i < this.codes.size(); ++i) {
            PyCodeConstant pyCodeConstant = this.codes.get(i);
            pyCodeConstant.put(code);
        }
        code.return_();
    }

    public void addFunctions() throws IOException {
        int n;
        Code code = this.classfile.addMethod("call_function", CodegenUtils.sig(PyObject.class, Integer.TYPE, PyFrame.class, ThreadState.class), 1);
        code.aload(0);
        code.aload(2);
        code.aload(3);
        Label label = new Label();
        Label[] labelArray = new Label[this.codes.size()];
        for (n = 0; n < labelArray.length; ++n) {
            labelArray[n] = new Label();
        }
        code.iload(1);
        code.tableswitch(0, labelArray.length - 1, label, labelArray);
        for (n = 0; n < labelArray.length; ++n) {
            code.label(labelArray[n]);
            code.invokevirtual(this.classfile.name, this.codes.get((int)n).fname, CodegenUtils.sig(PyObject.class, PyFrame.class, ThreadState.class));
            code.areturn();
        }
        code.label(label);
        code.aconst_null();
        code.areturn();
    }

    public void write(OutputStream outputStream) throws IOException {
        this.addInit();
        this.addRunnable();
        this.addMain();
        this.addBootstrap();
        this.addFunctions();
        this.classfile.addInterface(CodegenUtils.p(PyRunnable.class));
        if (this.sfilename != null) {
            this.classfile.setSource(this.sfilename);
        }
        this.classfile.write(outputStream);
    }

    public Future getFutures() {
        return this.futures;
    }

    public String getFilename() {
        return this.sfilename;
    }

    public ScopeInfo getScopeInfo(PythonTree pythonTree) {
        return this.scopes.get(pythonTree);
    }

    public void error(String string, boolean bl, PythonTree pythonTree) throws Exception {
        block3: {
            if (!bl) {
                try {
                    Py.warning(Py.SyntaxWarning, string, this.sfilename != null ? this.sfilename : "?", pythonTree.getLine(), null, Py.None);
                    return;
                }
                catch (PyException pyException) {
                    if (pyException.match(Py.SyntaxWarning)) break block3;
                    throw pyException;
                }
            }
        }
        throw new ParseException(string, pythonTree);
    }

    public static void compile(mod mod2, OutputStream outputStream, String string, String string2, boolean bl, boolean bl2, CompilerFlags compilerFlags) throws Exception {
        Module.compile(mod2, outputStream, string, string2, bl, bl2, compilerFlags, -1L);
    }

    public static void compile(mod mod2, OutputStream outputStream, String string, String string2, boolean bl, boolean bl2, CompilerFlags compilerFlags, long l) throws Exception {
        Module module = new Module(string, string2, bl, l);
        if (compilerFlags == null) {
            compilerFlags = new CompilerFlags();
        }
        module.futures.preprocessFutures(mod2, compilerFlags);
        new ScopesCompiler(module, module.scopes).parse(mod2);
        PyCodeConstant pyCodeConstant = module.codeConstant(mod2, "<module>", false, null, false, bl2, 0, module.getScopeInfo(mod2), compilerFlags);
        module.mainCode = pyCodeConstant;
        module.write(outputStream);
    }
}

